@echo off

REM  This SOFTWARE IS SUBJECT TO COPYRIGHT PROTECTION AND IS OFFERED ONLY
REM  PURSUANT TO THE 3DFX GLIDE GENERAL PUBLIC LICENSE. THERE IS NO RIGHT
REM  TO USE THE GLIDE TRADEMARK WITHOUT PRIOR WRITTEN PERMISSION OF 3DFX
REM  INTERACTIVE, INC. A COPY OF THIS LICENSE MAY BE OBTAINED FROM THE 
REM  DISTRIBUTOR OR BY CONTACTING 3DFX INTERACTIVE INC(info@3dfx.com). 
REM  THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
REM  EXPRESSED OR IMPLIED. SEE THE 3DFX GLIDE GENERAL PUBLIC LICENSE FOR A
REM  FULL TEXT OF THE NON-WARRANTY PROVISIONS.  
REM 
REM  USE, DUPLICATION OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT TO
REM  RESTRICTIONS AS SET FORTH IN SUBDIVISION (C)(1)(II) OF THE RIGHTS IN
REM  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013,
REM  AND/OR IN SIMILAR OR SUCCESSOR CLAUSES IN THE FAR, DOD OR NASA FAR
REM  SUPPLEMENT. UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF
REM  THE UNITED STATES.  
REM 
REM  COPYRIGHT 3DFX INTERACTIVE, INC. 1999, ALL RIGHTS RESERVED

REM ------------------------------------------
REM 3DFX BUILD ENVIRONMENT FOR GLIDE3
REM ------------------------------------------

REM ------------------------------------------
REM STORE THE PATH
REM ------------------------------------------
IF NOT "%OLDPATH%"=="" GOTO DONTSTORE
SET OLDPATH=%PATH%
:DONTSTORE


REM ---------------------------------------------------------
REM SET THE FOLLOWING VARIABLES (before attempting to compile
REM ---------------------------------------------------------

REM Set NMAKE to the directory containing nmake.exe.  This is usually
REM the MSVC\bin directory.
set NMAKE=d:\nmake

REM You must set BUILD_DRIVE to the drive that you are building on ex:
set BUILD_DRIVE=d:

REM You must set BUILD_ROOT to the root of where you extracted your
REM source kit to ex:
set BUILD_ROOT=d:\3dfx\devel

REM You must set MASM to the location of your Microsoft Assembler
REM directory.  3Dfx uses Masm 6.13. ex:
set MASM=c:\DevTools\masm613

REM You must set MSVC to the location of your Microsoft Visual C++
REM compiler.  3Dfx uses MSVC 4.2.  ex:
set MSVC=c:\DevTools\msvc42

REM You must set DIRECTXSDK to the location of your DirectX SDK 
REM 3Dfx requires DirectX 6 SDK
REM directory ex:
SET DIRECTXSDK=c:\DevTools\dx6\sdk

REM You must set DIRECTXDDK to the location of your DirectX DDK
REM 3Dfx requires DirectX 5 DDK (release 3)
REM directory ex:
SET DIRECTXDDK=c:\DevTools\dx5sdkr3\ddk

REM You must set FX_DLL_BUILD to 1 if you are attempting to build a Glide
REM DLL.  However, if you would just like to build static libs it must
REM be UN-set  (set FX_DLL_BUILD=).
REM set FX_DLL_BUILD=1 (will build .dll)
set FX_DLL_BUILD=1


REM No Modifications should need to be after here.



REM ------------------------------------------
REM CHECK CRITICAL VARS
REM ------------------------------------------
IF NOT "%BUILD_DRIVE%"=="" GOTO DRIVEDEFD
ECHO You must set the environment variable BUILD_DRIVE
ECHO   to the driver letter of the source tree.
ECHO eg. SET BUILD_DRIVE=d:
GOTO END
:DRIVEDEFD
IF NOT "%BUILD_ROOT%"=="" GOTO ROOTDEFD
ECHO You must set the environment variable BUILD_ROOT
ECHO    to the root directory of the source tree.
ECHO eg. SET BUILD_ROOT=\3dfx\devel 
ECHO NOTE: BUILD_ROOT doesn't need a drive letter.
GOTO END
:ROOTDEFD
IF NOT "%MASM%=="" GOTO MSVC
ECHO You must set the environment variable MASM
ECHO    To the install directory for 
ECHO    Microsoft Assember VERSION 6.11 ( or greater )
ECHO eg. SET MASM=C:\DEVEL\MASM611
GOTO END
:MSVC
IF NOT "%MSVC%"=="" GOTO MSVCDEFD
ECHO You must set the environment variable MSVC
ECHO   to the install directory for Microsoft 
ECHO   visual C/C++ 4.2 or greater
ECHO eg. SET MSVC=C:\devel\msdev
GOTO END

:MSVCDEFD
SET PATH=%MSVC%\bin;%OLDPATH%;%MASM%\bin

SET INCLUDE=%MSVC%\INCLUDE;%MSVC%\MFC\INCLUDE;%BUILD_ROOT_SWLIBS%\include
SET INCLUDE=%INCLUDE%;%BUILD_ROOT_SWLIBS%\include\nmake;%MASM%\INCLUDE

SET LIB=%MSVC%\lib;%MSVC%\MFC\lib;%MASM%\lib
SET AT_LOADER_MG=1


SET FX_COMPILER=MICROSOFT
SET FX_TARGET=WIN32
SET FX_HOST=DOS

REM ------------------------------------------
REM   SET COMMON VARS
REM ------------------------------------------
SET BUILD_ROOT_H3=%BUILD_ROOT%\H3
SET BUILD_ROOT_SWLIBS=%BUILD_ROOT%\swlibs
SET FX_GLIDE_HW=H3
SET FX_HW_PROJECTS=GLIDE3
SET FX_NO_GEN_BOF=1
SET FX_GLIDE_REAL_HW=1

set GLIDE_INIT_HWC=1
set FX_GLIDE_PACKET_FIFO=1
set DXDDK=%DIRECTXDDK%
set W9XDDK=%DIRECTXDDK%

:END

